DROP PROCEDURE IF EXISTS sp_insertUpdateDocumentoVenta;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_insertUpdateDocumentoVenta`(IN `p_idVenta` INT, 
	IN `p_idCliente` INT, IN `p_idTipoDocumento` INT, IN `p_idMoneda` INT, IN `p_idFormaPago` INT, 
    IN `p_idMedioPago` INT, IN `p_idCanal` INT, IN `p_fechaEmision` TIMESTAMP, IN `p_serie` VARCHAR(50), 
    IN `p_numero` VARCHAR(50), IN `p_tipoCambio` DECIMAL(18,3), 
    IN `p_igv` DECIMAL(18,3), IN `p_monto_subtotal` DECIMAL(18,6), IN `p_monto_descuento_total` DECIMAL(18,6), 
    IN `p_monto_igv_total` DECIMAL(18,6), IN `p_monto_total` DECIMAL(18,6), IN `p_monto_interes` DECIMAL(18,6), 
    IN `p_monto_total_interes` DECIMAL(18,6), IN p_tipoOperacion INT, IN `p_usuarioRegistro` VARCHAR(50))
BEGIN 
	
    DECLARE	tam int;
	DECLARE cuerpo varchar(6);
	DECLARE cuerpoFinal varchar(6);
	DECLARE aux varchar(6);
	DECLARE aux1 int;
	DECLARE aux2 int;
	DECLARE b int default 1;
	DECLARE _codigo varchar(9);
	
    IF p_tipoOperacion = 1 THEN
    
		IF p_idVenta IS NULL OR p_idVenta = 0 THEN
        
			SET cuerpo = (SELECT Max(SUBSTRING(correlativo,4,9)) FROM DOCUMENTO_VENTA);
			
			SET tam = length(cuerpo);
			
			
			IF (tam = 6) then
				set aux = cuerpo;
				set aux1 = cast(aux as UNSIGNED); 
				set aux2 = aux1 + b;
				
				set aux = cast(aux2 as char(6));
				while(length(aux)<6) DO
					set aux = concat('0',aux);
				end while; 
				
				set cuerpoFinal = aux;
				
			ELSE
				set aux = '0';
				set aux1 = cast(aux as UNSIGNED);
				set aux2 = aux1 + b;
				
				set aux = cast(aux2 as char(6)); 
				while(length(aux)<6) DO
					set aux = concat('0',aux);
				end while;
				
				set cuerpoFinal = aux;         
				 
			END IF;
			
			SET _codigo = concat('DV-',cuerpoFinal);
        
			INSERT INTO DOCUMENTO_VENTA(
										idCliente,
										idTipoDocumento,
										idMoneda,
                                        idFormaPago,
                                        idMedioPago,
                                        idCanal,
                                        correlativo,
                                        fecha_emision,
                                        serie,
                                        numero,
                                        tasa_cambio,
                                        igv,
                                        monto_subtotal,
                                        monto_descuento_total,
                                        monto_igv_total,
                                        monto_total,
                                        monto_interes,
                                        monto_total_interes,
                                        estado,
                                        fecha_registro,
                                        usuario_registro,
                                        pc_registro,
                                        fecha_edicion,
                                        usuario_edicion,
                                        pc_edicion,
                                        activo
										)
								VALUES	(
										p_idCliente,
										p_idTipoDocumento,
										p_idMoneda,
										p_idFormaPago,
										p_idMedioPago,
										p_idCanal,
                                        _codigo,
                                        p_fechaEmision,
										p_serie,
										p_numero,
                                        p_tipoCambio,
                                        p_igv,
										p_monto_subtotal,
										p_monto_descuento_total,
										p_monto_igv_total,
										p_monto_total,
										p_monto_interes,
										p_monto_total_interes,
                                        'A',
                                        NOW(),
										p_usuarioRegistro,
                                        @@hostname,
                                        NOW(),
										p_usuarioRegistro,
                                        @@hostname,
										1
										);
			SELECT	1 AS tipoRespuesta,
					'EL documento se regitró correctamente !' AS respuesta,
                    LAST_INSERT_ID() AS id;
		ELSE    
			UPDATE	DOCUMENTO_VENTA
            SET		idCliente = p_idCliente,
					idTipoDocumento = p_idTipoDocumento,
					idMoneda = p_idMoneda,
					idFormaPago = p_idFormaPago,
					idMedioPago = p_idMedioPago,
					idCanal = p_idCanal,
					fecha_emision = p_fechaEmision,
					serie = p_serie,
					numero = p_numero,
                    tasa_cambio = p_tipoCambio,
                    igv = p_igv,
					monto_subtotal = p_monto_subtotal,
					monto_descuento_total = p_monto_descuento_total,
					monto_igv_total = p_monto_igv_total,
					monto_total = p_monto_total,
					monto_interes = p_monto_interes,
					monto_total_interes = p_monto_total_interes,
					fecha_edicion = NOW(),
					usuario_edicion = p_usuarioRegistro,
					pc_edicion = @@hostname
			WHERE	id = p_idVenta;
            
			SELECT	1 AS tipoRespuesta,
					'EL documento se editó correctamente !' AS respuesta,
					p_idVenta AS id;
		END IF;
	END IF;
    
    IF p_tipoOperacion = 2 THEN
    
		IF p_idVenta IS NULL OR p_idVenta = 0 THEN
        
			SET cuerpo = (SELECT Max(SUBSTRING(correlativo,4,9)) FROM DOCUMENTO_VENTA);
			
			SET tam = length(cuerpo);
			
			
			IF (tam = 6) then
				set aux = cuerpo;
				set aux1 = cast(aux as UNSIGNED); 
				set aux2 = aux1 + b;
				
				set aux = cast(aux2 as char(6));
				while(length(aux)<6) DO
					set aux = concat('0',aux);
				end while; 
				
				set cuerpoFinal = aux;
				
			ELSE
				set aux = '0';
				set aux1 = cast(aux as UNSIGNED);
				set aux2 = aux1 + b;
				
				set aux = cast(aux2 as char(6)); 
				while(length(aux)<6) DO
					set aux = concat('0',aux);
				end while;
				
				set cuerpoFinal = aux;         
				 
			END IF;
			
			SET _codigo = concat('DV-',cuerpoFinal);
        
			INSERT INTO DOCUMENTO_VENTA(
										idCliente,
										idTipoDocumento,
										idMoneda,
                                        idFormaPago,
                                        idMedioPago,
                                        idCanal,
                                        correlativo,
                                        fecha_emision,
                                        serie,
                                        numero,
                                        tasa_cambio,
                                        igv,
                                        monto_subtotal,
                                        monto_descuento_total,
                                        monto_igv_total,
                                        monto_total,
                                        monto_interes,
                                        monto_total_interes,
                                        estado,
                                        fecha_registro,
                                        usuario_registro,
                                        pc_registro,
                                        fecha_edicion,
                                        usuario_edicion,
                                        pc_edicion,
                                        activo
										)
								VALUES	(
										p_idCliente,
										p_idTipoDocumento,
										p_idMoneda,
										p_idFormaPago,
										p_idMedioPago,
										p_idCanal,
                                        _codigo,
                                        p_fechaEmision,
										p_serie,
										p_numero,
                                        p_tipoCambio,
                                        p_igv,
										p_monto_subtotal,
										p_monto_descuento_total,
										p_monto_igv_total,
										p_monto_total,
										p_monto_interes,
										p_monto_total_interes,
                                        'C',
                                        NOW(),
										p_usuarioRegistro,
                                        @@hostname,
                                        NOW(),
										p_usuarioRegistro,
                                        @@hostname,
										1
										);
			SELECT	1 AS tipoRespuesta,
					'EL documento se cerró correctamente !' AS respuesta,
                    LAST_INSERT_ID() AS id;
		ELSE    
			UPDATE	DOCUMENTO_VENTA
            SET		idCliente = p_idCliente,
					idTipoDocumento = p_idTipoDocumento,
					idMoneda = p_idMoneda,
					idFormaPago = p_idFormaPago,
					idMedioPago = p_idMedioPago,
					idCanal = p_idCanal,
					fecha_emision = p_fechaEmision,
					serie = p_serie,
					numero = p_numero,
                    tasa_cambio = p_tipoCambio,
                    igv = p_igv,
					monto_subtotal = p_monto_subtotal,
					monto_descuento_total = p_monto_descuento_total,
					monto_igv_total = p_monto_igv_total,
					monto_total = p_monto_total,
					monto_interes = p_monto_interes,
					monto_total_interes = p_monto_total_interes,
                    estado = 'C',
					fecha_edicion = NOW(),
					usuario_edicion = p_usuarioRegistro,
					pc_edicion = @@hostname
			WHERE	id = p_idVenta;
            
			SELECT	1 AS tipoRespuesta,
					'EL documento se cerró correctamente !' AS respuesta,
					p_idVenta AS id;
		END IF;
	END IF;
END
$